<x-app-layout title="Manage Roles">

    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-8">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Settings</p>
            <h1 class="text-3xl font-semibold mt-2">Roles & Permissions</h1>
            <p class="text-sm text-textSecondary">Create roles and attach permissions</p>
        </div>
        <a href="{{ route('settings.index') }}" class="text-primary text-sm hover:underline">← Back to Settings</a>
    </div>

    <div class="grid md:grid-cols-2 gap-6">
        <div class="bg-white border border-borderColor rounded-3xl shadow-sm p-6">
            <h2 class="text-lg font-semibold text-textPrimary mb-4">Add Role</h2>
            <form action="{{ route('settings.roles.store') }}" method="POST" class="space-y-4">
                @csrf
                <div>
                    <label class="text-sm font-medium text-textSecondary mb-2 block">Name</label>
                    <input type="text" name="name" value="{{ old('name') }}"
                           class="w-full rounded-2xl border border-borderColor px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="e.g. Inventory Lead" required>
                </div>

                <div>
                    <p class="text-sm font-medium text-textSecondary mb-2">Permissions</p>
                    <div class="grid md:grid-cols-2 gap-2 max-h-64 overflow-y-auto custom-scroll">
                        @foreach($permissions as $permission)
                            <label class="flex items-center gap-2 text-sm text-textSecondary border border-borderColor/60 rounded-2xl px-3 py-2">
                                <input type="checkbox" name="permissions[]" value="{{ $permission->name }}"
                                       class="rounded border-borderColor text-primary focus:ring-primary/40">
                                <span>{{ $permission->name }}</span>
                            </label>
                        @endforeach
                    </div>
                </div>

                @if ($errors->any())
                    <div class="rounded-2xl bg-red-50 border border-red-200 text-sm text-red-600 px-4 py-3">
                        <ul class="list-disc list-inside space-y-1">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <button type="submit"
                        class="px-6 py-3 rounded-2xl bg-primary text-white font-semibold shadow-sm">
                    Save Role
                </button>
            </form>
        </div>

        <div class="bg-white border border-borderColor rounded-3xl shadow-sm p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-lg font-semibold text-textPrimary">Existing Roles</h2>
                <span class="badge-pill bg-slate-100 text-textSecondary text-xs">{{ $roles->count() }} total</span>
            </div>

            <div class="space-y-4">
                @forelse($roles as $role)
                    <div class="border border-borderColor/60 rounded-2xl px-4 py-3 text-sm">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="font-semibold text-textPrimary">{{ $role->name }}</p>
                                <p class="text-xs text-textSecondary">{{ $role->permissions->count() }} permissions</p>
                            </div>
                            <div class="space-x-2">
                                <a href="{{ route('settings.roles.edit', $role->id) }}" class="text-primary text-xs font-semibold">Edit</a>
                                <form action="{{ route('settings.roles.destroy', $role->id) }}" method="POST" class="inline" onsubmit="return confirm('Delete this role?')">
                                    @csrf
                                    @method('DELETE')
                                    <button class="text-red-500 text-xs font-semibold">Delete</button>
                                </form>
                            </div>
                        </div>
                        <p class="mt-2 text-textSecondary">{{ $role->permissions->pluck('name')->implode(', ') ?: 'No permissions' }}</p>
                    </div>
                @empty
                    <p class="text-sm text-textSecondary">No roles defined.</p>
                @endforelse
            </div>
        </div>
    </div>

</x-app-layout>
