<x-app-layout title="Sale Details">

    <section class="flex flex-col gap-4 md:flex-row md:items-center md:justify-between">
        <div>
            <p class="text-sm uppercase tracking-[0.3em] text-textSecondary">Invoice</p>
            <h1 class="text-3xl font-semibold mt-2 text-textPrimary">{{ $sale->invoice_number }}</h1>
            <p class="text-sm text-textSecondary mt-1">Sale date: {{ \Illuminate\Support\Carbon::parse($sale->sale_date)->format('M d, Y') }}</p>
        </div>
        <div class="flex items-center gap-3">
            <a href="{{ route('sales.index') }}" class="text-primary text-sm hover:underline">← Back to sales</a>
            <button type="button"
                    onclick="window.print()"
                    class="px-4 py-2 rounded-xl bg-primary text-white text-sm font-medium shadow-sm">
                Print Invoice
            </button>
        </div>
    </section>

    <section class="bg-white rounded-3xl shadow-sm border border-borderColor p-6 mt-8 flex flex-col md:flex-row md:justify-between gap-6">
        <div class="space-y-2 text-sm text-textSecondary">
            <div class="flex items-center gap-3">
                {{-- <div class="w-12 h-12 rounded-full bg-primary text-white flex items-center justify-center text-xl font-semibold">
                    QL
                </div> --}}
                <div>
                    {{-- <p class="text-lg font-semibold text-textPrimary">QuantumLedger</p> --}}
                    <img src="{{ asset('img/logo_lanscate.png') }}" alt="Logo" class="h-12 w-28 object-contain">
                    <p class="text-xs">KneaYerng-VIP</p>
                </div>
            </div>
            <p>Sangkat Phom Penh Tmey, Khan Sen Sok, Phnom Penh.</p>
            <p>Phone: <span class="text-textPrimary">081 515 245</span></p>
            <p>E-mail: <span class="text-textPrimary">seavminh22220@gmail.com</span></p>
        </div>
        <div class="space-y-1 text-sm text-textSecondary md:text-right">
            <p><span class="font-semibold text-textPrimary">Date:</span> {{ \Illuminate\Support\Carbon::parse($sale->sale_date)->format('d M Y') }}</p>
            <p><span class="font-semibold text-textPrimary">Invoice ID:</span> {{ $sale->invoice_number }}</p>
        </div>
    </section>

    @php
        $taxValue = $sale->tax ?? 0;
        $discountValue = $sale->discount ?? 0;
        $amountValue = $sale->amount ?? max(0, $sale->total_amount + $taxValue - $discountValue);
        $profitValue = $sale->profit;
        $paidTimeDisplay = 'N/A';
        if ($sale->paid_time) {
            try {
                $format = strlen($sale->paid_time) === 5 ? 'H:i' : 'H:i:s';
                $paidTimeDisplay = \Illuminate\Support\Carbon::createFromFormat($format, $sale->paid_time)->format('g:i A');
            } catch (\Exception $e) {
                $paidTimeDisplay = $sale->paid_time;
            }
        }
    @endphp

    <div class="grid md:grid-cols-3 gap-6 mt-6">
        <section class="bg-white rounded-3xl shadow-sm border border-borderColor p-6 space-y-4 md:col-span-1">
            <h2 class="text-lg font-semibold text-textPrimary">Summary</h2>
            <div class="flex justify-between text-sm text-textSecondary">
                <span>Customer</span>
                <span class="font-semibold text-textPrimary">{{ $sale->customer_id ?? 'Walk-in' }}</span>
            </div>
            <div class="flex justify-between text-sm text-textSecondary">
                <span>Customer Phone</span>
                <span class="font-semibold text-textPrimary">{{ $sale->customer_phone ?? 'N/A' }}</span>
            </div>
            <div class="flex justify-between text-sm text-textSecondary">
                <span>Branch</span>
                <span class="font-semibold text-textPrimary">{{ $sale->branch->name ?? 'N/A' }}</span>
            </div>
            <div class="flex justify-between text-sm text-textSecondary">
                <span>Quantity</span>
                <span class="font-semibold text-textPrimary">{{ $sale->total_qty ?? $sale->items->sum('qty') }}</span>
            </div>
            <div class="flex justify-between text-sm text-textSecondary">
                <span>Payment Status</span>
                <span class="px-2 py-1 rounded-full bg-slate-100 text-textPrimary text-xs font-semibold">{{ $sale->payment_method }}</span>
            </div>
            <div class="flex justify-between text-sm text-textSecondary">
                <span>Status</span>
                <span class="px-2 py-1 rounded-full bg-emerald-50 text-emerald-600 text-xs font-semibold">{{ ucfirst($sale->status) }}</span>
            </div>
            <div class="flex justify-between text-sm text-textSecondary">
                <span>Date</span>
                <span>{{ \Illuminate\Support\Carbon::parse($sale->sale_date)->format('M d, Y') }}</span>
            </div>
            <div class="flex justify-between text-sm text-textSecondary">
                <span>Tax</span>
                <span class="font-semibold text-textPrimary">${{ number_format($taxValue, 2) }}</span>
            </div>
            <div class="flex justify-between text-sm text-textSecondary">
                <span>Discount</span>
                <span class="font-semibold text-textPrimary">- ${{ number_format($discountValue, 2) }}</span>
            </div>
            @if($sale->payment_method === 'Bank + Cash')
                <div class="flex justify-between text-sm text-textSecondary">
                    <span>Bank Portion</span>
                    <span class="font-semibold text-textPrimary">${{ number_format($sale->bank_amount ?? 0, 2) }}</span>
                </div>
                <div class="flex justify-between text-sm text-textSecondary">
                    <span>Cash Portion</span>
                    <span class="font-semibold text-textPrimary">${{ number_format($sale->cash_amount ?? 0, 2) }}</span>
                </div>
            @endif
            <div class="flex justify-between text-sm text-textSecondary">
                <span>Amount Paid</span>
                <span class="font-semibold text-textPrimary">${{ number_format($amountValue, 2) }}</span>
            </div>
            <div class="flex justify-between text-sm text-textSecondary">
                <span>Profit</span>
                <span class="font-semibold text-textPrimary">
                    @if($profitValue !== null)
                        ${{ number_format($profitValue, 2) }}
                    @else
                        N/A
                    @endif
                </span>
            </div>
            <div class="flex justify-between text-sm text-textSecondary">
                <span>Paid Time</span>
                <span class="font-semibold text-textPrimary">{{ $paidTimeDisplay }}</span>
            </div>
            <div>
                <p class="text-sm text-textSecondary">Total Amount</p>
                <p class="text-3xl font-semibold mt-1 text-textPrimary">${{ number_format($sale->total_amount, 2) }}</p>
            </div>
            @if($sale->other)
                <div class="pt-2 border-t border-borderColor/60 text-sm text-textSecondary">
                    <p class="font-semibold text-textPrimary">Other Notes</p>
                    <p class="mt-1 leading-relaxed">{{ $sale->other }}</p>
                </div>
            @endif
        </section>

        <section class="bg-white rounded-3xl shadow-sm border border-borderColor p-6 md:col-span-2 space-y-4">
            <div class="flex items-center justify-between">
                <h2 class="text-2xl font-semibold text-textPrimary">Invoice</h2>
                <span class="text-sm text-textSecondary">Total Qty: {{ $sale->total_qty ?? $sale->items->sum('qty') }}</span>
            </div>

            <div class="rounded-2xl border border-borderColor overflow-hidden">
                <table class="w-full text-sm">
                    <thead class="bg-bgLight text-textSecondary uppercase text-xs tracking-wide">
                        <tr>
                            <th class="px-4 py-3 text-left">Product</th>
                            <th class="px-4 py-3 text-center">Qty</th>
                            <th class="px-4 py-3 text-right">Price</th>
                            <th class="px-4 py-3 text-right">Total</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white">
                        @forelse($sale->items as $item)
                            <tr class="border-t border-borderColor/60">
                                <td class="px-4 py-3">
                                    @if($item->product_type === 'computer')
                                        <p class="font-semibold text-textPrimary">{{ $item->computerProduct->name ?? 'Computer Product' }}</p>
                                        <p class="text-xs text-textSecondary">Code {{ $item->computerProduct->product_code ?? '—' }} · SN {{ $item->serial_number ?? '—' }}</p>
                                    @else
                                        <p class="font-semibold text-textPrimary">{{ $item->variation->product->name ?? 'Product' }}</p>
                                        <p class="text-xs text-textSecondary">Serial {{ $item->serial_number ?? '—' }}</p>
                                    @endif
                                </td>
                                <td class="px-4 py-3 text-center">{{ $item->qty }}</td>
                                <td class="px-4 py-3 text-right">${{ number_format($item->price, 2) }}</td>
                                <td class="px-4 py-3 text-right font-semibold">${{ number_format($item->qty * $item->price, 2) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="px-4 py-6 text-center text-textSecondary">No items recorded.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </section>
    </div>

    <section class="mt-8 bg-white rounded-3xl shadow-sm border border-borderColor p-6 space-y-6">
        <div>
            <h3 class="text-lg font-semibold text-textPrimary mb-2">Terms &amp; Conditions</h3>
            <p class="text-sm text-textSecondary leading-relaxed">
                Goods sold are non-refundable. Payment must be settled via approved methods (ABA, AC, Wing, Bank, Cash, Bank + Cash, Cash with delivery).
                For delivery payments, please prepare the exact amount. Contact us immediately if there are discrepancies within 24 hours of receipt.
            </p>
        </div>

        <div class="grid md:grid-cols-2 gap-6 text-sm text-textSecondary">
            <div>
                <p>Phnom Penh, 26 OCT 2025</p>
            </div>
            <div class="grid grid-cols-2 gap-4 text-center">
                <div>
                    <p class="uppercase tracking-wide text-xs text-textSecondary">Approved By</p>
                    <div class="h-12 border-b border-dashed border-borderColor mt-6"></div>
                </div>
                <div>
                    <p class="uppercase tracking-wide text-xs text-textSecondary">Authorized By</p>
                    <div class="h-12 border-b border-dashed border-borderColor mt-6"></div>
                </div>
            </div>
        </div>
    </section>

</x-app-layout>
