<x-app-layout title="Repairs">

    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-6">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Repairs</p>
            <h1 class="text-3xl font-semibold mt-2">Repair Tickets</h1>
            <p class="text-sm text-textSecondary mt-1">Monitor device repairs across branches</p>
        </div>
        @can('technical.create')
        <a href="{{ route('repairs.create') }}"
           class="px-5 py-3 rounded-2xl bg-primary text-white font-semibold shadow-sm text-sm">
            + New Repair
        </a>
        @endcan
    </div>

    <div class="bg-white border border-borderColor rounded-3xl shadow-sm overflow-hidden">
        <div class="overflow-x-auto custom-scroll">
            <table class="w-full text-sm">
                <thead class="bg-bgLight text-textSecondary uppercase text-xs tracking-wide">
                    <tr>
                        <th class="px-6 py-3 text-left">Code</th>
                        <th class="px-6 py-3 text-left">Device</th>
                        <th class="px-6 py-3 text-left">Issue</th>
                        <th class="px-6 py-3 text-center">Status</th>
                        <th class="px-6 py-3 text-left">Created</th>
                        <th class="px-6 py-3 text-right">Actions</th>
                    </tr>
                </thead>

                <tbody class="bg-white">
                    @forelse ($repairs as $repair)
                        <tr class="border-t border-borderColor/60 hover:bg-bgLight/60 transition">
                            <td class="px-6 py-4 font-semibold text-textPrimary">{{ $repair->repair_code }}</td>
                            <td class="px-6 py-4">{{ $repair->device_model }}</td>
                            <td class="px-6 py-4 text-textSecondary">{{ \Illuminate\Support\Str::limit($repair->issue, 40) }}</td>
                            <td class="px-6 py-4 text-center">
                                <span class="px-3 py-1 rounded-full text-xs font-semibold
                                    @if($repair->status === 'completed') bg-emerald-50 text-emerald-600
                                    @elseif($repair->status === 'in_progress') bg-amber-50 text-amber-600
                                    @elseif($repair->status === 'delivered') bg-blue-50 text-blue-600
                                    @else bg-slate-100 text-slate-600 @endif">
                                    {{ ucwords(str_replace('_', ' ', $repair->status)) }}
                                </span>
                            </td>
                            <td class="px-6 py-4">{{ $repair->created_at->format('M d, Y') }}</td>
                            <td class="px-6 py-4 text-right space-x-3">
                                <a href="{{ route('repairs.show', $repair->id) }}" class="text-primary text-sm font-semibold">View</a>
                                <a href="{{ route('repairs.edit', $repair->id) }}" class="text-textSecondary text-sm">Edit</a>
                                <form action="{{ route('repairs.destroy', $repair->id) }}" method="POST" class="inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-500 text-sm" onclick="return confirm('Delete this repair?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-10 text-center text-textSecondary">No repairs yet.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="px-6 py-4 border-t border-borderColor/60">
            {{ $repairs->links() }}
        </div>
    </div>

</x-app-layout>
