<x-app-layout title="Product Details">

    <div class="flex items-center justify-between">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Product</p>
            <h1 class="text-3xl font-semibold mt-2">{{ $product->name }}</h1>
            <p class="text-sm text-textSecondary mt-1">SKU count: {{ $product->variations->count() }}</p>
            <p class="text-sm text-textSecondary">Category ID: {{ $product->category_code ?? '—' }}</p>
        </div>
        <a href="{{ route('products.index') }}" class="text-primary hover:underline text-sm">← Back to list</a>
    </div>

    <div class="grid md:grid-cols-3 gap-6 mt-8">
        <div class="glass-card rounded-3xl p-6 md:col-span-1">
            <p class="text-xs uppercase tracking-[0.4em] text-textSecondary">Overview</p>
            <div class="mt-4 space-y-3 text-sm">
                <div class="flex justify-between">
                    <span class="text-textSecondary">Category ID</span>
                    <span class="font-semibold">{{ $product->category_code ?? '—' }}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-textSecondary">Selling Price</span>
                    <span class="font-semibold">${{ number_format($product->selling_price, 2) }}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-textSecondary">Cost Price</span>
                    <span class="font-semibold">${{ number_format($product->cost_price, 2) }}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-textSecondary">Status</span>
                    <span class="badge-pill {{ $product->is_active ? 'bg-emerald-50 text-emerald-600' : 'bg-red-50 text-red-600' }}">
                        {{ $product->is_active ? 'Active' : 'Inactive' }}
                    </span>
                </div>
                <div class="flex justify-between">
                    <span class="text-textSecondary">Created</span>
                    <span>{{ $product->created_at?->format('M d, Y') }}</span>
                </div>
            </div>
        </div>

        <div class="glass-card rounded-3xl p-6 md:col-span-2">
            <div class="flex items-center justify-between flex-wrap gap-4">
                <div>
                    <h2 class="text-xl font-semibold">Variations</h2>
                    <p class="text-sm text-textSecondary">Linked SKUs & stock tracking</p>
                </div>
            </div>

            <form method="POST" action="{{ route('variations.store') }}" class="mt-6 space-y-4">
                @csrf
                <input type="hidden" name="product_id" value="{{ $product->id }}">
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-xs font-semibold text-textSecondary mb-1">Next SKU</label>
                        <input type="text" value="{{ $nextSku }}" readonly
                               class="w-full rounded-2xl border border-white/50 bg-slate-50 px-4 py-2 text-sm text-textSecondary">
                    </div>
                    <div>
                        <label class="block text-xs font-semibold text-textSecondary mb-1">Color</label>
                        <select name="color"
                                class="w-full rounded-2xl border border-white/50 bg-white/70 px-4 py-2 text-sm focus:ring-primary/40 focus:border-primary/50"
                                required>
                            <option value="">Select</option>
                            @foreach(config('products.colors', ['Black', 'Silver', 'White']) as $colorOption)
                                <option value="{{ $colorOption }}" @selected(old('color') === $colorOption)>{{ $colorOption }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-xs font-semibold text-textSecondary mb-1">Storage</label>
                        <select name="storage"
                                class="w-full rounded-2xl border border-white/50 bg-white/70 px-4 py-2 text-sm focus:ring-primary/40 focus:border-primary/50">
                            <option value="">Select (optional)</option>
                            @foreach(config('products.storages', ['32GB', '64GB', '128GB', '256GB', '512GB', '1TB']) as $storageOption)
                                <option value="{{ $storageOption }}" @selected(old('storage') === $storageOption)>{{ $storageOption }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label class="block text-xs font-semibold text-textSecondary mb-1">Barcode</label>
                        <input type="text" name="barcode" value="{{ old('barcode') }}"
                               class="w-full rounded-2xl border border-white/50 bg-white/70 px-4 py-2 text-sm focus:ring-primary/40 focus:border-primary/50"
                               placeholder="Optional">
                    </div>
                </div>
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-xs font-semibold text-textSecondary mb-1">IMEI</label>
                        <input type="text" name="imei" value="{{ old('imei') }}"
                               class="w-full rounded-2xl border border-white/50 bg-white/70 px-4 py-2 text-sm focus:ring-primary/40 focus:border-primary/50"
                               placeholder="Unique IMEI">
                    </div>
                    <div>
                        <label class="block text-xs font-semibold text-textSecondary mb-1">Serial Number</label>
                        <input type="text" name="serial_number" value="{{ old('serial_number') }}"
                               class="w-full rounded-2xl border border-white/50 bg-white/70 px-4 py-2 text-sm focus:ring-primary/40 focus:border-primary/50"
                               placeholder="Device serial">
                    </div>
                </div>
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-xs font-semibold text-textSecondary mb-1">Condition (SC / New)</label>
                        <select name="condition"
                                class="w-full rounded-2xl border border-white/50 bg-white/70 px-4 py-2 text-sm focus:ring-primary/40 focus:border-primary/50"
                                required>
                            @foreach(config('products.conditions', ['SC' => 'SC', 'New' => 'New']) as $conditionKey => $conditionLabel)
                                <option value="{{ $conditionKey }}" @selected(old('condition', 'New') === $conditionKey)>{{ $conditionLabel }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label class="block text-xs font-semibold text-textSecondary mb-1">Network (AT / NT optional)</label>
                        <select name="network_status"
                                class="w-full rounded-2xl border border-white/50 bg-white/70 px-4 py-2 text-sm focus:ring-primary/40 focus:border-primary/50">
                            <option value="">Select</option>
                            @foreach(config('products.network_statuses', ['AT' => 'AT', 'NT' => 'NT']) as $statusKey => $statusLabel)
                                <option value="{{ $statusKey }}" @selected(old('network_status') === $statusKey)>{{ $statusLabel }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="flex justify-end">
                    <button type="submit"
                            class="px-4 py-2 rounded-2xl bg-primary text-white text-sm shadow shadow-primary/30">
                        Add Variation
                    </button>
                </div>
            </form>

            @if ($errors->any())
                <div class="rounded-2xl bg-red-50 border border-red-100 text-xs text-red-600 px-4 py-3 mt-4">
                    <ul class="list-disc list-inside space-y-1">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="mt-6 space-y-4">
                @forelse($product->variations as $variation)
                    <div class="rounded-2xl border border-white/60 bg-white/80 px-4 py-4 space-y-3 text-sm">
                        <div class="flex items-center justify-between gap-4 flex-wrap">
                            <div>
                                <p class="font-semibold">SKU: {{ $variation->sku }}</p>
                                <p class="text-textSecondary text-xs">Barcode: {{ $variation->barcode ?? '—' }}</p>
                            </div>
                            <span class="badge-pill bg-slate-100 text-textSecondary">Variation #{{ $variation->id }}</span>
                        </div>
                        <div class="grid md:grid-cols-3 gap-3 text-xs text-textSecondary">
                            <div>
                                <p class="font-semibold text-textPrimary">Color</p>
                                <p>{{ $variation->color ?? '—' }}</p>
                            </div>
                            <div>
                                <p class="font-semibold text-textPrimary">Storage</p>
                                <p>{{ $variation->storage ?? '—' }}</p>
                            </div>
                            <div>
                                <p class="font-semibold text-textPrimary">Condition</p>
                                <p>{{ $variation->condition ?? '—' }}</p>
                            </div>
                            <div>
                                <p class="font-semibold text-textPrimary">IMEI</p>
                                <p>{{ $variation->imei ?? '—' }}</p>
                            </div>
                            <div>
                                <p class="font-semibold text-textPrimary">Serial #</p>
                                <p>{{ $variation->serial_number ?? '—' }}</p>
                            </div>
                            <div>
                                <p class="font-semibold text-textPrimary">Network</p>
                                <p>{{ $variation->network_status ?? '—' }}</p>
                            </div>
                        </div>
                    </div>
                @empty
                    <p class="text-sm text-textSecondary">No variations yet. Add your first SKU above.</p>
                @endforelse
            </div>
        </div>
    </div>

</x-app-layout>
