<x-app-layout title="Create Product">

    <div class="flex items-center justify-between">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Products</p>
            <h1 class="text-3xl font-semibold mt-2">New Product</h1>
            <p class="text-sm text-textSecondary mt-1">Add a device with pricing and status</p>
        </div>
        <a href="{{ route('products.index') }}" class="text-primary hover:underline text-sm">← Back to list</a>
    </div>

    <form action="{{ route('products.store') }}" method="POST" class="glass-card rounded-3xl p-8 mt-8 space-y-6">
        @csrf

        <div class="grid md:grid-cols-2 gap-6">
            <div>
                <label class="block text-sm font-medium text-textSecondary mb-2">Product Name</label>
                <input type="text" name="name" value="{{ old('name') }}"
                       class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                       placeholder="e.g. iPhone 15 Pro" required>
            </div>

            <div>
                <label class="block text-sm font-medium text-textSecondary mb-2">Category ID</label>
                <input type="text" value="{{ $nextCategoryCode }}"
                       class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary"
                       readonly>
                <p class="text-xs text-textSecondary mt-1">Automatically generated (e.g. CAT-001) when saving.</p>
            </div>
        </div>

        <div class="grid md:grid-cols-2 gap-6">
            <div>
                <label class="block text-sm font-medium text-textSecondary mb-2">Selling Price</label>
                <input type="number" step="0.01" min="0" name="selling_price" value="{{ old('selling_price') }}"
                       class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                       placeholder="0.00" required>
            </div>

            <div>
                <label class="block text-sm font-medium text-textSecondary mb-2">Cost Price</label>
                <input type="number" step="0.01" min="0" name="cost_price" value="{{ old('cost_price') }}"
                       class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                       placeholder="0.00" required>
            </div>
        </div>

        <div class="glass-card rounded-3xl p-6 space-y-4">
            <h2 class="text-lg font-semibold">Default Variation</h2>
            <p class="text-sm text-textSecondary">This variation lets the product appear in purchase orders immediately.</p>

            <div class="grid md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-textSecondary mb-2">SKU</label>
                    <input type="text" value="{{ $nextSku }}"
                           class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary"
                           readonly>
                    <p class="text-xs text-textSecondary mt-1">Generated automatically (SKU001, SKU002, ...)</p>
                </div>

                <div>
                    <label class="block text-sm font-medium text-textSecondary mb-2">Barcode</label>
                    <input type="text" name="barcode" value="{{ old('barcode') }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="Optional barcode reference">
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-textSecondary mb-2">Color</label>
                    <select name="color"
                            class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                            required>
                        <option value="">Select a color</option>
                        @foreach(config('products.colors', ['Black', 'Silver', 'White']) as $colorOption)
                            <option value="{{ $colorOption }}" @selected(old('color') === $colorOption)>{{ $colorOption }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-textSecondary mb-2">Storage</label>
                    <select name="storage"
                            class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50">
                        <option value="">Select storage (optional)</option>
                        @foreach(config('products.storages', ['32GB', '64GB', '128GB', '256GB', '512GB', '1TB']) as $storageOption)
                            <option value="{{ $storageOption }}" @selected(old('storage') === $storageOption)>{{ $storageOption }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-textSecondary mb-2">IMEI</label>
                    <input type="text" name="imei" value="{{ old('imei') }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="Unique IMEI">
                </div>
                <div>
                    <label class="block text-sm font-medium text-textSecondary mb-2">Serial Number</label>
                    <input type="text" name="serial_number" value="{{ old('serial_number') }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="Device serial">
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-textSecondary mb-2">Condition (SC / New)</label>
                    <select name="condition"
                            class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                            required>
                        @foreach(config('products.conditions', ['SC' => 'SC', 'New' => 'New']) as $conditionKey => $conditionLabel)
                            <option value="{{ $conditionKey }}" @selected(old('condition', 'New') === $conditionKey)>{{ $conditionLabel }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-textSecondary mb-2">Network (AT / NT optional)</label>
                    <select name="network_status"
                            class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50">
                        <option value="">Select status (optional)</option>
                        @foreach(config('products.network_statuses', ['AT' => 'AT', 'NT' => 'NT']) as $statusKey => $statusLabel)
                            <option value="{{ $statusKey }}" @selected(old('network_status') === $statusKey)>{{ $statusLabel }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-textSecondary mb-2">Initial Stock (optional)</label>
                    <input type="number" min="0" name="initial_stock" value="{{ old('initial_stock') }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="0">
                    <p class="text-xs text-textSecondary mt-1">Applies to your current branch. Leave blank if you will add stock later via purchases.</p>
                </div>
            </div>
        </div>

        <div class="flex items-center justify-between rounded-2xl border border-white/60 bg-white/70 px-6 py-4">
            <div>
                <p class="font-medium text-textPrimary">Active Product</p>
                <p class="text-sm text-textSecondary">Toggle off to temporarily hide from workflows</p>
            </div>
            <label class="inline-flex items-center cursor-pointer">
                <input type="hidden" name="is_active" value="0">
                <input type="checkbox" name="is_active" value="1" class="sr-only peer" {{ old('is_active', true) ? 'checked' : '' }}>
                <span class="w-12 h-6 bg-gray-200 rounded-full peer-checked:bg-primary transition relative">
                    <span class="absolute top-0.5 left-0.5 w-5 h-5 bg-white rounded-full shadow peer-checked:translate-x-6 transition"></span>
                </span>
            </label>
        </div>

        @if ($errors->any())
            <div class="rounded-2xl bg-red-50 border border-red-100 text-sm text-red-600 px-4 py-3">
                <ul class="list-disc list-inside space-y-1">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="flex justify-end">
            <button type="submit"
                    class="px-6 py-3 rounded-2xl bg-gradient-to-r from-primary to-primaryDark text-white shadow-lg shadow-primary/40">
                Save Product
            </button>
        </div>
    </form>

</x-app-layout>
