<x-app-layout title="Computer Product Manager">
    <div class="flex items-center justify-between flex-wrap gap-4">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Computers</p>
            <h1 class="text-3xl font-semibold mt-2">Computer Inventory</h1>
            <p class="text-sm text-textSecondary mt-1">View curated specs for laptops and desktops.</p>
        </div>
        <a href="{{ route('computers.create') }}"
           class="inline-flex items-center gap-2 px-4 py-2 rounded-2xl bg-primary text-white shadow shadow-primary/30 text-sm">
            + Create Computer Product
        </a>
    </div>

    <div class="glass-card rounded-3xl p-6 mt-8 space-y-4">
        @if(session('success'))
            <div class="rounded-2xl border border-emerald-200 bg-emerald-50 text-emerald-700 px-4 py-2 text-sm">
                {{ session('success') }}
            </div>
        @endif

        <div class="flex items-center justify-between flex-wrap gap-2">
            <div>
                <h2 class="text-lg font-semibold">Catalog</h2>
                <p class="text-sm text-textSecondary">Overview of configured computer builds.</p>
            </div>
            <span class="text-xs bg-primary/10 text-primary px-3 py-1 rounded-full">{{ $computers->count() }} Items</span>
        </div>

        <div class="rounded-2xl border border-white/60 bg-white/80 p-4">
            <form action="{{ route('computers.import') }}" method="POST" enctype="multipart/form-data"
                  class="space-y-4" x-data="{ fileName: '' }">
                @csrf
                <label class="flex flex-col items-center justify-center gap-3 rounded-2xl border-2 border-dashed border-borderColor/70 px-6 py-8 text-center cursor-pointer hover:border-primary/60 transition">
                    <div class="h-12 w-12 rounded-full bg-primary/10 text-primary flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 16V8m0 0-3 3m3-3 3 3M4 16v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-2"/>
                        </svg>
                    </div>
                    <div>
                        <p class="font-semibold text-textPrimary">Click or drop CSV/XLSX to import computers</p>
                        <p class="text-xs text-textSecondary mt-1" x-text="fileName ? `Selected: ${fileName}` : 'Allowed formats: .csv, .xlsx (max 5MB)'"></p>
                    </div>
                    <input type="file" name="import_file" accept=".csv,.xlsx" class="hidden"
                           @change="fileName = $event.target.files[0]?.name || ''">
                </label>
                <div class="flex items-center justify-between flex-wrap gap-3">
                    <p class="text-xs text-textSecondary">Required headers: product_code, name, display, cpu, capacity, ram, storage, color, country_code, condition, status, serial_number, cost, tax, stock_qty.</p>
                    <button type="submit"
                            class="px-4 py-2 rounded-2xl bg-primary text-white shadow shadow-primary/30 text-sm hover:bg-primary/90 transition">
                        Import File
                    </button>
                </div>
            </form>
            @error('import_file')
                <p class="text-sm text-red-500 mt-2">{{ $message }}</p>
            @enderror
        </div>

        <div class="overflow-x-auto rounded-2xl border border-white/60">
            <table class="min-w-full text-sm">
                <thead class="bg-white/70 text-left text-xs uppercase tracking-wide text-textSecondary">
                    <tr>
                        <th class="px-4 py-3">Product ID</th>
                        <th class="px-4 py-3">Product Name</th>
                        <th class="px-4 py-3">Display</th>
                        <th class="px-4 py-3">CPU</th>
                        <th class="px-4 py-3">Capacity</th>
                        <th class="px-4 py-3">RAM</th>
                        <th class="px-4 py-3">Storage</th>
                        <th class="px-4 py-3">Color</th>
                        <th class="px-4 py-3">Country</th>
                        <th class="px-4 py-3">Condition</th>
                        <th class="px-4 py-3">Status</th>
                        <th class="px-4 py-3 text-center">Stock Qty</th>
                        <th class="px-4 py-3 text-right">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($computers as $computer)
                        <tr class="border-t border-white/60">
                            <td class="px-4 py-3 font-semibold">{{ $computer->product_code }}</td>
                            <td class="px-4 py-3">{{ $computer->name }}</td>
                            <td class="px-4 py-3">{{ $computer->display }}</td>
                            <td class="px-4 py-3">{{ $computer->cpu }}</td>
                            <td class="px-4 py-3">{{ $computer->capacity }}</td>
                            <td class="px-4 py-3">{{ $computer->ram }}</td>
                            <td class="px-4 py-3">{{ $computer->storage }}</td>
                            <td class="px-4 py-3">{{ $computer->color }}</td>
                            <td class="px-4 py-3">{{ $computer->country_code }}</td>
                            <td class="px-4 py-3">{{ $computer->condition }}</td>
                            <td class="px-4 py-3">
                                <span class="px-3 py-1 rounded-full text-xs {{ $computer->status === 'Active' ? 'bg-green-100 text-green-700' : 'bg-gray-200 text-gray-600' }}">
                                    {{ $computer->status }}
                                </span>
                            </td>
                            <td class="px-4 py-3 text-center">
                                <span class="px-3 py-1 rounded-full text-xs {{ $computer->stock_qty > 0 ? 'bg-emerald-50 text-emerald-700' : 'bg-red-50 text-red-600' }}">
                                    {{ $computer->stock_qty }}
                                </span>
                            </td>
                            <td class="px-4 py-3 text-right space-x-2">
                                <a href="{{ route('computers.show', $computer) }}" class="text-primary text-sm hover:underline">View</a>
                                <a href="{{ route('computers.edit', $computer) }}" class="text-amber-600 text-sm hover:underline">Edit</a>
                                <form action="{{ route('computers.destroy', $computer) }}" method="POST" class="inline" onsubmit="return confirm('Delete this computer product?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 text-sm hover:underline">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="12" class="px-4 py-6 text-center text-textSecondary">No computer products available.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</x-app-layout>
