<x-app-layout :title="'Edit '.$computer->name">
    @php
        $options = config('computers');
    @endphp

    <div class="flex items-center justify-between flex-wrap gap-4">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Computers</p>
            <h1 class="text-3xl font-semibold mt-2">Edit Computer Product</h1>
            <p class="text-sm text-textSecondary mt-1">Update specs, stock, and identifiers.</p>
        </div>
        <a href="{{ route('computers.show', $computer) }}"
           class="inline-flex items-center px-4 py-2 rounded-2xl border border-white/60 text-sm text-textSecondary hover:text-primary">
            ← Back to details
        </a>
    </div>

    <div class="glass-card rounded-3xl p-6 mt-8">
        <form action="{{ route('computers.update', $computer) }}" method="POST" class="space-y-5">
            @csrf
            @method('PUT')
            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Product ID</label>
                    <input type="text" name="product_code" value="{{ old('product_code', $computer->product_code) }}"
                           class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary" required>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Product Name</label>
                    <input type="text" name="name" value="{{ old('name', $computer->name) }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           required>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Display</label>
                    <select name="display" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        @foreach($options['displays'] as $display)
                            <option value="{{ $display }}" @selected(old('display', $computer->display) === $display)>{{ $display }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">CPU</label>
                    <select name="cpu" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        @foreach($options['cpus'] as $cpu)
                            <option value="{{ $cpu }}" @selected(old('cpu', $computer->cpu) === $cpu)>{{ $cpu }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Capacity</label>
                    <select name="capacity" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        @foreach($options['capacities'] as $capacity)
                            <option value="{{ $capacity }}" @selected(old('capacity', $computer->capacity) === $capacity)>{{ $capacity }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">RAM</label>
                    <select name="ram" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        @foreach($options['rams'] as $ram)
                            <option value="{{ $ram }}" @selected(old('ram', $computer->ram) === $ram)>{{ $ram }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Storage</label>
                    <select name="storage" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        @foreach($options['storages'] as $storage)
                            <option value="{{ $storage }}" @selected(old('storage', $computer->storage) === $storage)>{{ $storage }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Color</label>
                    <select name="color" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        @foreach($options['colors'] as $color)
                            <option value="{{ $color }}" @selected(old('color', $computer->color) === $color)>{{ $color }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Country Code</label>
                    <select name="country_code" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        @foreach($options['countries'] as $country)
                            <option value="{{ $country }}" @selected(old('country_code', $computer->country_code) === $country)>{{ $country }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Condition</label>
                    <select name="condition" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        @foreach($options['conditions'] as $condition)
                            <option value="{{ $condition }}" @selected(old('condition', $computer->condition) === $condition)>{{ $condition }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Status</label>
                    <select name="status" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        @foreach($options['statuses'] as $status)
                            <option value="{{ $status }}" @selected(old('status', $computer->status) === $status)>{{ $status }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Serial Number</label>
                    <input type="text" name="serial_number" value="{{ old('serial_number', $computer->serial_number) }}" maxlength="10"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           required>
                </div>
            </div>

            <div class="grid md:grid-cols-3 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Cost</label>
                    <input type="number" step="0.01" min="0" name="cost" value="{{ old('cost', $computer->cost) }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           required>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Tax</label>
                    <input type="number" step="0.01" min="0" name="tax" value="{{ old('tax', $computer->tax) }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50">
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Stock Qty</label>
                    <input type="number" min="0" name="stock_qty" value="{{ old('stock_qty', $computer->stock_qty) }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           required>
                </div>
            </div>

            @if ($errors->any())
                <div class="rounded-2xl border border-red-200 bg-red-50 text-red-600 text-sm px-4 py-3">
                    <ul class="list-disc list-inside space-y-1">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="flex justify-end gap-3">
                <a href="{{ route('computers.show', $computer) }}"
                   class="px-4 py-2 rounded-2xl border border-white/60 text-textSecondary">Cancel</a>
                <button type="submit"
                        class="px-6 py-3 rounded-2xl bg-gradient-to-r from-primary to-primaryDark text-white shadow-lg shadow-primary/40">
                    Save Changes
                </button>
            </div>
        </form>
    </div>
</x-app-layout>
