<x-app-layout title="Create Computer Product">
    @php
        $options = config('computers');
@endphp
    <div class="flex items-center justify-between flex-wrap gap-4">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Computers</p>
            <h1 class="text-3xl font-semibold mt-2">Create Computer Product</h1>
            <p class="text-sm text-textSecondary mt-1">Define specs with curated dropdowns and set starting stock.</p>
        </div>
        <a href="{{ route('computers.index') }}"
           class="inline-flex items-center px-4 py-2 rounded-2xl border border-white/60 text-sm text-textSecondary hover:text-primary">
            ← Back to list
        </a>
    </div>

    <div class="glass-card rounded-3xl p-6 mt-8">
        <form action="{{ route('computers.store') }}" method="POST" class="space-y-5">
            @csrf
            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Product ID</label>
                    <input type="text" name="product_code" value="{{ old('product_code', $nextCode) }}"
                           class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary" readonly>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Product Name</label>
                    <input type="text" name="name" value="{{ old('name') }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="e.g. MacBook Pro 16&quot;" required>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Display</label>
                    <select name="display" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Display</option>
                        @foreach($options['displays'] as $display)
                            <option value="{{ $display }}" @selected(old('display') === $display)>{{ $display }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">CPU</label>
                    <select name="cpu" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select CPU</option>
                        @foreach($options['cpus'] as $cpu)
                            <option value="{{ $cpu }}" @selected(old('cpu') === $cpu)>{{ $cpu }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Capacity</label>
                    <select name="capacity" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Capacity</option>
                        @foreach($options['capacities'] as $capacity)
                            <option value="{{ $capacity }}" @selected(old('capacity') === $capacity)>{{ $capacity }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">RAM</label>
                    <select name="ram" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select RAM</option>
                        @foreach($options['rams'] as $ram)
                            <option value="{{ $ram }}" @selected(old('ram') === $ram)>{{ $ram }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Storage</label>
                    <select name="storage" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Storage</option>
                        @foreach($options['storages'] as $storage)
                            <option value="{{ $storage }}" @selected(old('storage') === $storage)>{{ $storage }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Color</label>
                    <select name="color" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Color</option>
                        @foreach($options['colors'] as $color)
                            <option value="{{ $color }}" @selected(old('color') === $color)>{{ $color }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Country Code</label>
                    <select name="country_code" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Country</option>
                        @foreach($options['countries'] as $country)
                            <option value="{{ $country }}" @selected(old('country_code') === $country)>{{ $country }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Condition</label>
                    <select name="condition" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Condition</option>
                        @foreach($options['conditions'] as $condition)
                            <option value="{{ $condition }}" @selected(old('condition') === $condition)>{{ $condition }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Activate</label>
                    <select name="status" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Status</option>
                        @foreach($options['statuses'] as $status)
                            <option value="{{ $status }}" @selected(old('status', 'Active') === $status)>{{ $status }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Serial Number</label>
                    <input type="text" name="serial_number" value="{{ old('serial_number') }}" maxlength="10"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="SN (max 10)" required>
                </div>
            </div>

            <div class="grid md:grid-cols-3 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Cost</label>
                    <input type="number" step="0.01" min="0" name="cost" value="{{ old('cost') }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="0.00" required>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Tax</label>
                    <input type="number" step="0.01" min="0" name="tax" value="{{ old('tax', 0) }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="0.00">
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Stock Qty</label>
                    <input type="number" min="0" name="stock_qty" value="{{ old('stock_qty') }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           placeholder="0" required>
                </div>
            </div>

            @if ($errors->any())
                <div class="rounded-2xl border border-red-200 bg-red-50 text-sm text-red-600 px-4 py-3">
                    <ul class="list-disc list-inside space-y-1">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="flex justify-end">
                <button type="submit"
                        class="px-6 py-3 rounded-2xl bg-gradient-to-r from-primary to-primaryDark text-white shadow-lg shadow-primary/40">
                    Save Computer Product
                </button>
            </div>
        </form>
    </div>
</x-app-layout>
