<header class="h-20 glass-card flex items-center justify-between px-8 sticky top-0 z-20">

    {{-- Search Bar --}}
    <div class="relative w-1/3 hidden md:block">
        <span class="absolute left-4 top-1/2 -translate-y-1/2 text-sm text-textSecondary">
            🔍
        </span>
        <input type="text"
               placeholder="Search anything..."
               class="w-full pl-10 pr-4 py-3 rounded-2xl bg-white/70 border border-white/40 text-sm focus:ring-2 focus:ring-primary/40 focus:border-primary/50 transition">
    </div>

    <div class="flex items-center space-x-5">

        {{-- Branch Selector --}}
        <form method="POST" action="/branch/switch/{{ auth()->user()->branch_id }}">
            @csrf
            <select name="branch" onchange="this.form.submit()"
                class="bg-white/80 border border-white/40 rounded-2xl px-4 py-2 text-sm focus:ring-2 focus:ring-primary/30 transition cursor-pointer">
                @foreach(\App\Models\Branch::all() as $b)
                    <option value="{{ $b->id }}" {{ $b->id == auth()->user()->branch_id ? 'selected' : '' }}>
                        {{ $b->name }}
                    </option>
                @endforeach
            </select>
        </form>

        {{-- User Profile --}}
        <div class="flex items-center space-x-3">
            <div class="w-10 h-10 rounded-full bg-gradient-to-br from-primary to-primaryDark text-white flex items-center justify-center shadow-lg">
                {{ strtoupper(substr(auth()->user()->name, 0, 1)) }}
            </div>
            <div>
                <p class="text-sm font-semibold">{{ auth()->user()->name }}</p>
                <p class="text-xs text-textSecondary">{{ auth()->user()->email }}</p>
            </div>
        </div>

        <form method="POST" action="{{ route('logout') }}">
            @csrf
            <button type="submit"
                    class="flex items-center gap-2 px-4 py-2 rounded-2xl bg-slate-100 text-slate-700 text-sm font-semibold hover:bg-slate-200 transition">
                <span>⇦</span>
                Logout
            </button>
        </form>
    </div>

</header>
