<x-guest-layout>
    <div class="space-y-6">
        <div>
            <h1 class="text-2xl font-semibold text-slate-900">Log in</h1>
            <p class="mt-1 text-sm text-slate-500">Access your phone inventory dashboard.</p>
        </div>

        <!-- Session Status -->
        <x-auth-session-status class="rounded-lg border border-slate-200 bg-slate-50 px-4 py-3 text-sm text-slate-800" :status="session('status')" />

        <form method="POST" action="{{ route('login') }}" class="space-y-5">
            @csrf

            <!-- Email Address -->
            <div class="space-y-2">
                <x-input-label class="text-slate-700" for="email" :value="__('Email')" />
                <x-text-input id="email" class="block w-full rounded-lg border-slate-300 bg-white px-4 py-3 text-sm focus:border-indigo-500 focus:ring-2 focus:ring-indigo-500 focus:ring-offset-1" type="email" name="email" :value="old('email')" required autofocus autocomplete="username" />
                <x-input-error :messages="$errors->get('email')" class="mt-1" />
            </div>

            <!-- Password -->
            <div class="space-y-2">
                <div class="flex items-center justify-between">
                    <x-input-label class="text-slate-700" for="password" :value="__('Password')" />
                    @if (Route::has('password.request'))
                        <a class="text-sm font-medium text-indigo-600 hover:text-indigo-700 focus:outline-none focus:underline" href="{{ route('password.request') }}">
                            {{ __('Forgot password?') }}
                        </a>
                    @endif
                </div>

                <x-text-input id="password" class="block w-full rounded-lg border-slate-300 bg-white px-4 py-3 text-sm focus:border-indigo-500 focus:ring-2 focus:ring-indigo-500 focus:ring-offset-1"
                                type="password"
                                name="password"
                                required autocomplete="current-password" />

                <x-input-error :messages="$errors->get('password')" class="mt-1" />
            </div>

            <!-- Remember Me -->
            <div class="flex items-center justify-between">
                <label for="remember_me" class="inline-flex items-center gap-3 text-sm text-slate-600">
                    <input id="remember_me" type="checkbox" class="rounded border-slate-300 text-indigo-600 shadow-sm focus:ring-indigo-500" name="remember">
                    <span>{{ __('Remember me') }}</span>
                </label>

                {{-- @if (Route::has('register'))
                    <a class="text-sm font-medium text-slate-600 hover:text-slate-900 focus:underline" href="{{ route('register') }}">
                        {{ __('Create account') }}
                    </a>
                @endif --}}
            </div>

            <x-primary-button class="w-full justify-center rounded-lg bg-indigo-600 px-4 py-3 text-sm font-semibold text-white normal-case tracking-normal hover:bg-indigo-700 focus:bg-indigo-700 active:bg-indigo-800">
                {{ __('Log in') }}
            </x-primary-button>
        </form>
    </div>
</x-guest-layout>
