<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionSeeder extends Seeder
{
    public function run(): void
    {
        $resources = [
            'dashboard' => ['view'],
            'products' => ['view', 'create', 'update', 'delete'],
            'variations' => ['view', 'create', 'update', 'delete'],
            'purchases' => ['view', 'create', 'update', 'delete'],
            'sales' => ['view', 'create', 'update', 'delete'],
            'stock' => ['view'],
            'expenses' => ['view', 'create', 'update', 'delete'],
            'suppliers' => ['view', 'create', 'update', 'delete'],
            'profile' => ['view', 'update'],
            'technical' => ['view', 'create', 'update', 'delete'],
            'settings' => ['view', 'update'],
            'computers' => ['view', 'create', 'update', 'delete'],
        ];

        $allPermissions = [];

        foreach ($resources as $resource => $actions) {
            foreach ($actions as $action) {
                $name = "{$resource}.{$action}";
                $permission = Permission::firstOrCreate(['name' => $name, 'guard_name' => 'web']);
                $allPermissions[] = $permission->name;
            }
        }

        $roleMatrix = [
            'Admin' => $allPermissions,
            'Manager' => $this->permissionsForResources($resources, [
                'dashboard', 'products', 'variations', 'purchases', 'sales', 'stock', 'expenses', 'profile', 'suppliers', 'computers',
            ]),
            'Sales' => $this->permissionsForResources($resources, ['dashboard', 'sales', 'products', 'computers']),
            'Technician' => $this->permissionsForResources($resources, ['dashboard', 'technical']),
            'Accountant' => $this->permissionsForResources($resources, ['dashboard', 'expenses', 'purchases']),
        ];

        foreach ($roleMatrix as $roleName => $permissionNames) {
            $role = Role::firstOrCreate(['name' => $roleName], ['guard_name' => 'web']);
            $role->syncPermissions($permissionNames);
        }
    }

    protected function permissionsForResources(array $resources, array $selected): array
    {
        return collect($resources)
            ->only($selected)
            ->flatMap(fn ($actions, $resource) => collect($actions)->map(fn ($action) => "{$resource}.{$action}"))
            ->values()
            ->all();
    }
}
