<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('computer_products', function (Blueprint $table) {
            $table->id();
            $table->string('product_code')->unique();
            $table->string('name');
            $table->string('display');
            $table->string('cpu');
            $table->string('capacity');
            $table->string('ram');
            $table->string('storage');
            $table->string('color');
            $table->string('country_code');
            $table->string('condition');
            $table->string('status')->default('Active');
            $table->string('serial_number', 10);
            $table->decimal('cost', 12, 2);
            $table->decimal('tax', 12, 2)->default(0);
            $table->integer('stock_qty')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('computer_products');
    }
};
