<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
{
    Schema::create('repairs', function (Blueprint $table) {
        $table->id();
        $table->string('repair_code')->unique();
        $table->unsignedBigInteger('customer_id');
        $table->string('device_model');
        $table->string('issue');
        $table->enum('status', ['pending', 'in_progress', 'completed', 'delivered'])->default('pending');
        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('repairs');
    }
};
