<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StockMovement extends Model
{
    protected $fillable = [
        'branch_id',
        'variation_id',
        'type',
        'qty',
        'reference'
    ];

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function variation()
    {
        return $this->belongsTo(ProductVariation::class);
    }
}

