<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SaleItem extends Model
{
    protected $fillable = [
        'sale_id',
        'product_type',
        'variation_id',
        'computer_product_id',
        'serial_number',
        'qty',
        'price',
    ];

    public function sale()
    {
        return $this->belongsTo(Sale::class);
    }

    public function variation()
    {
        return $this->belongsTo(ProductVariation::class);
    }

    public function computerProduct()
    {
        return $this->belongsTo(ComputerProduct::class);
    }
}
