<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Sale extends Model
{
    protected $fillable = [
        'invoice_number',
        'customer_id',
        'customer_phone',
        'branch_id',
        'sale_date',
        'total_amount',
        'amount',
        'profit',
        'paid_time',
        'other',
        'tax',
        'discount',
        'bank_amount',
        'cash_amount',
        'payment_method',
        'status'
    ];

    public function items()
    {
        return $this->hasMany(SaleItem::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }
}
