<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Purchase extends Model
{
    protected $fillable = [
        'po_number',
        'purchase_code',
        'invoice_number',
        's_invoice_number',
        'supplier_id',
        'purchase_date',
        'total_amount',
        'tax_amount',
        'other_charges',
        'total_due',
        'status',
        'purchase_type',
    ];

    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }

    public function items()
    {
        return $this->hasMany(PurchaseItem::class);
    }
}
