<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $fillable = [
        'name',
        'category_code',
        'selling_price',
        'cost_price',
        'is_active'
    ];

    public static function nextCategoryCode(): string
    {
        $latestCode = static::whereNotNull('category_code')->orderByDesc('id')->value('category_code');

        if ($latestCode && preg_match('/CAT-(\d+)/', $latestCode, $matches)) {
            $nextNumber = (int) $matches[1] + 1;
        } else {
            $nextNumber = 1;
        }

        return 'CAT-' . str_pad((string) $nextNumber, 3, '0', STR_PAD_LEFT);
    }

    public function variations()
    {
        return $this->hasMany(ProductVariation::class);
    }
}
