<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ComputerProduct extends Model
{
    use HasFactory;

    protected $fillable = [
        'product_code',
        'name',
        'display',
        'cpu',
        'capacity',
        'ram',
        'storage',
        'color',
        'country_code',
        'condition',
        'status',
        'serial_number',
        'cost',
        'tax',
        'stock_qty',
    ];

    protected $appends = ['total_cost'];

    public function getTotalCostAttribute(): float
    {
        return (float) ($this->cost + $this->tax);
    }
}
