<?php

namespace App\Http\Controllers;

use App\Models\Expense;
use App\Http\Controllers\SalesController;
use Illuminate\Http\Request;

class ExpenseController extends Controller
{
    public function index()
    {
        $expenses = Expense::latest()->paginate(20);
        $paymentMethods = app(SalesController::class)->paymentMethods();
        return view('expenses.index', compact('expenses', 'paymentMethods'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'category' => 'nullable',
            'category_custom' => 'nullable|string|max:255',
            'amount' => 'required',
            'payment_type' => 'nullable|string|max:255',
            'expense_date' => 'nullable|date',
        ]);

        $category = $validated['category_custom'] ?: $validated['category'];

        if (!$category) {
            return back()->withErrors(['category' => 'Please choose or enter a category.'])->withInput();
        }

        Expense::create([
            'branch_id' => auth()->user()->branch_id,
            'category' => $category,
            'amount' => $validated['amount'],
            'payment_type' => $validated['payment_type'],
            'expense_date' => $validated['expense_date'],
        ]);

        return back();
    }
}
