<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($computer->name)]); ?>
    <div class="flex items-center justify-between flex-wrap gap-4">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Computer Product</p>
            <h1 class="text-3xl font-semibold mt-2"><?php echo e($computer->name); ?></h1>
            <p class="text-sm text-textSecondary mt-1">Product ID: <?php echo e($computer->product_code); ?></p>
        </div>
        <div class="flex items-center gap-3">
            <a href="<?php echo e(route('computers.index')); ?>" class="text-primary text-sm hover:underline">Back to list</a>
            <a href="<?php echo e(route('computers.edit', $computer)); ?>" class="px-4 py-2 rounded-2xl bg-primary text-white text-sm shadow shadow-primary/30">Edit</a>
            <form action="<?php echo e(route('computers.destroy', $computer)); ?>" method="POST" onsubmit="return confirm('Delete this computer product?');">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="px-4 py-2 rounded-2xl bg-red-50 text-red-600 text-sm shadow">Delete</button>
            </form>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="mt-6 rounded-2xl border border-emerald-200 bg-emerald-50 text-emerald-700 px-4 py-2 text-sm">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="glass-card rounded-3xl p-6 mt-8 grid md:grid-cols-2 gap-6">
        <div class="space-y-4">
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Description</p>
                <p class="text-lg font-semibold text-textPrimary"><?php echo e($computer->description); ?></p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">CodeName</p>
                <p class="text-lg font-semibold text-textPrimary"><?php echo e($computer->code_name); ?></p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Internal ID</p>
                <p class="text-lg font-semibold text-textPrimary"><?php echo e($computer->internal_id); ?></p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Display</p>
                <p class="text-lg font-semibold text-textPrimary"><?php echo e($computer->display); ?></p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">CPU</p>
                <p class="text-lg font-semibold text-textPrimary"><?php echo e($computer->cpu); ?></p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Capacity / RAM / Storage</p>
                <p class="text-lg font-semibold text-textPrimary"><?php echo e($computer->capacity); ?> / <?php echo e($computer->ram); ?> / <?php echo e($computer->storage); ?></p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Color</p>
                <p class="text-lg font-semibold text-textPrimary"><?php echo e($computer->color_code); ?> - <?php echo e($computer->color); ?></p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Country</p>
                <p class="text-lg font-semibold text-textPrimary"><?php echo e($computer->country_code); ?> - <?php echo e($computer->country); ?></p>
            </div>
        </div>

        <div class="space-y-4">
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Condition</p>
                <p class="text-lg font-semibold text-textPrimary"><?php echo e($computer->condition); ?></p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Activate</p>
                <p class="text-lg font-semibold text-textPrimary"><?php echo e($computer->activate); ?></p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Cost / Tax</p>
                <p class="text-lg font-semibold text-textPrimary">$<?php echo e(number_format($computer->cost, 2)); ?> + $<?php echo e(number_format($computer->tax, 2)); ?></p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Stock</p>
                <p class="text-lg font-semibold text-textPrimary"><?php echo e($computer->stock_qty); ?></p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Created / Updated</p>
                <p class="text-sm text-textPrimary"><?php echo e($computer->created_at?->format('M d, Y g:i A')); ?> - <?php echo e($computer->updated_at?->format('M d, Y g:i A')); ?></p>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH D:\Work with client\New folder\phone_inventory_system 3\phone_inventory_system\resources\views/computers/show.blade.php ENDPATH**/ ?>