<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($title ?? 'Dashboard'); ?></title>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>

<body class="relative text-textPrimary min-h-screen">

    
    <div class="pointer-events-none absolute inset-0 overflow-hidden">
        <div class="absolute -right-16 top-10 w-64 h-64 bg-primary/10 blur-3xl rounded-full animate-soft-bounce"></div>
        <div class="absolute left-12 bottom-0 w-72 h-72 bg-primaryLight/20 blur-3xl rounded-full animate-soft-bounce" style="animation-delay: .8s;"></div>
    </div>

    <div class="relative flex min-h-screen">
        
        <?php echo $__env->make('components.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <div class="flex-1 flex flex-col min-h-screen ml-64">
            
            <?php echo $__env->make('components.topbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            
            <main class="flex-1 px-8 pb-10 pt-6">
                <div class="animate-fade-up space-y-6">
                    <?php echo e($slot); ?>

                </div>
            </main>
        </div>
    </div>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH D:\Work with client\New folder\phone_inventory_system 3\phone_inventory_system\resources\views/layouts/app.blade.php ENDPATH**/ ?>