<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Expenses']); ?>

    <h1 class="text-xl font-semibold mb-6">Expenses</h1>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('expenses.create')): ?>
    <div class="bg-white border border-borderColor rounded-3xl shadow-sm p-6 mb-8">
        <form action="<?php echo e(route('expenses.store')); ?>" method="POST" class="grid md:grid-cols-5 gap-4">
            <?php echo csrf_field(); ?>

            <div class="md:col-span-2 space-y-2">
                <label class="text-sm text-textSecondary font-medium">Category</label>
                <div class="flex gap-2">
                    <select name="category"
                            class="w-1/2 rounded-2xl border border-borderColor px-3 py-2 focus:ring-primary/40 focus:border-primary/50">
                        <option value="" disabled selected>Select preset</option>
                        <?php $__currentLoopData = ['Electricity', 'Water', 'WiFi', 'Employees', 'Training & software', 'Tax Registration', 'CCTV', 'Printer']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($category); ?>"><?php echo e($category); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <input name="category_custom" type="text" placeholder="Or type custom"
                           class="w-1/2 rounded-2xl border border-borderColor px-3 py-2 focus:ring-primary/40 focus:border-primary/50">
                </div>
            </div>

            <div>
                <label class="text-sm text-textSecondary font-medium">Amount</label>
                <input name="amount" type="number" step="0.01" placeholder="Amount"
                       class="w-full rounded-2xl border border-borderColor px-3 py-2 focus:ring-primary/40 focus:border-primary/50" required>
            </div>

            <div>
                <label class="text-sm text-textSecondary font-medium">Payment Type</label>
                <select name="payment_type"
                        class="w-full rounded-2xl border border-borderColor px-3 py-2 focus:ring-primary/40 focus:border-primary/50">
                    <option value="" disabled selected>Select method</option>
                    <?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($method); ?>"><?php echo e($method); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div>
                <label class="text-sm text-textSecondary font-medium">Date</label>
                <input name="expense_date" type="date"
                       class="w-full rounded-2xl border border-borderColor px-3 py-2 focus:ring-primary/40 focus:border-primary/50" value="<?php echo e(now()->toDateString()); ?>">
            </div>

            <div class="md:col-span-5 flex justify-end">
                <button class="px-6 py-3 rounded-2xl bg-primary text-white font-semibold shadow-sm">
                    Add Expense
                </button>
            </div>
        </form>
    </div>
    <?php endif; ?>

    <div class="bg-white p-6 rounded-xl shadow border">
        <table class="w-full text-sm">
            <thead>
                <tr class="border-b text-textSecondary">
                    <th class="py-2">Category</th>
                    <th class="py-2">Amount</th>
                    <th class="py-2">Payment</th>
                    <th class="py-2">Date</th>
                </tr>
            </thead>

            <tbody>
                <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="border-b">
                        <td class="py-3"><?php echo e($e->category); ?></td>
                        <td>$<?php echo e($e->amount); ?></td>
                        <td><?php echo e($e->payment_type); ?></td>
                        <td><?php echo e($e->expense_date); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>

        </table>

        <div class="mt-4">
            <?php echo e($expenses->links()); ?>

        </div>

    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH D:\Work with client\New folder\phone_inventory_system 3\phone_inventory_system\resources\views/expenses/index.blade.php ENDPATH**/ ?>