<aside class="w-64 glass-card h-screen fixed left-0 top-0 px-4 py-6 flex flex-col border border-white/60">

    
    <div class="px-3">
        
        <img src="<?php echo e(asset('img/logo_lanscate.png')); ?>" alt="Logo">
        <p class="text-xs text-textSecondary mt-1">KneaYerng-VIP</p>
    </div>

    <?php
        $links = [
            ['label' => 'Dashboard', 'route' => 'dashboard', 'permission' => 'dashboard.view'],
            ['label' => 'Purchase Orders', 'route' => 'purchases.index', 'permission' => 'purchases.view'],
            ['label' => 'Sales', 'route' => 'sales.index', 'permission' => 'sales.view'],
            ['label' => 'Repairs', 'route' => 'repairs.index', 'permission' => 'technical.view'],
            ['label' => 'Products', 'route' => 'products.index', 'permission' => 'products.view'],
            [
                'label' => 'Products of Computer',
                'route' => 'computers.index',
                'permission' => 'computers.view',
                'active' => 'computers.*',
            ],
            ['label' => 'Stock Levels', 'route' => 'stock.index', 'permission' => 'stock.view'],
            ['label' => 'Expenses', 'route' => 'expenses.index', 'permission' => 'expenses.view'],
            ['label' => 'Suppliers', 'route' => 'suppliers.index', 'permission' => 'suppliers.view'],
            ['label' => 'Profile', 'route' => 'profile.show', 'permission' => 'profile.view'],
            ['label' => 'Settings', 'route' => 'settings.index', 'permission' => 'settings.view'],
        ];
    ?>

    <?php
        $user = auth()->user();
    ?>

    <nav class="mt-6 flex-1 overflow-y-auto custom-scroll">
        <p class="text-[11px] uppercase tracking-[0.2em] text-textSecondary/70 px-3 mb-2">Menu</p>
        <ul class="space-y-2">
            <?php $__currentLoopData = $links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($user && ($user->hasRole('Super Admin') || $user->can($link['permission']))): ?>
                    <li>
                        <?php
                            $activePattern = $link['active'] ?? $link['route'];
                            $isActive = request()->routeIs($activePattern);
                        ?>
                        <a href="<?php echo e(route($link['route'])); ?>"
                           class="nav-link <?php echo e($isActive ? 'nav-link-active' : ''); ?>">
                            <span><?php echo e($link['label']); ?></span>
                            <?php if($isActive): ?>
                                <span class="badge-pill bg-white/20 text-white text-[10px]">Active</span>
                            <?php endif; ?>
                        </a>
                    </li>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </nav>

    <div class="mt-4 glass-card rounded-2xl px-4 py-3 text-xs text-textSecondary shadow-inner shadow-white/40">
        <p class="font-semibold text-textPrimary">System Status</p>
        <p class="mt-1 text-emerald-600 font-medium flex items-center gap-1">
            <span class="w-2 h-2 rounded-full bg-emerald-500 animate-pulse"></span>
            Online
        </p>
    </div>
</aside>
<?php /**PATH D:\Work with client\New folder\phone_inventory_system 3\phone_inventory_system\resources\views/components/sidebar.blade.php ENDPATH**/ ?>