<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name', 'Laravel')); ?></title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>
    <body class="font-sans text-slate-900 antialiased bg-slate-100">
        <div class="min-h-screen flex items-center justify-center px-4 py-10">
            <div class="w-full max-w-2xl bg-white border border-slate-200 shadow-lg rounded-2xl overflow-hidden">
                <div class="flex items-center gap-3 px-8 pt-8">
                    <img src="<?php echo e(asset('img/logo_lanscate.png')); ?>" alt="Lanscate logo" class="object-contain">
                    <div>
                        
                        
                    </div>
                </div>

                <div class="px-8 pb-10 pt-6">
                    <?php echo e($slot); ?>

                </div>
            </div>
        </div>
    </body>
</html>
<?php /**PATH E:\Work with client\New folder\phone_inventory_system 3\phone_inventory_system\resources\views/layouts/guest.blade.php ENDPATH**/ ?>