<x-app-layout title="Stock Levels">

    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Inventory</p>
            <h1 class="text-3xl font-semibold mt-2">Stock Levels</h1>
            <p class="text-sm text-textSecondary mt-1">Real-time balance by variation for your branch</p>
        </div>
    </div>

    <div class="mt-8 bg-white border border-borderColor rounded-3xl shadow-sm"
         x-data="{ mode: 'phone', computerStock: @js($computerStock) }">
        <div class="p-6 border-b border-borderColor/70 flex items-center justify-between gap-4 flex-wrap">
            <div>
                <p class="text-sm text-textSecondary">Branch</p>
                <p class="font-semibold text-textPrimary">{{ auth()->user()->branch->name ?? 'N/A' }}</p>
            </div>
            <div class="text-sm text-textSecondary text-right">
                <p>Last synced</p>
                <p class="font-semibold text-textPrimary">{{ now()->format('M d, Y g:i A') }}</p>
            </div>
        </div>

        <div class="p-4 flex flex-col gap-4 border-b border-borderColor/60 md:flex-row md:items-center md:justify-between">
            <div class="flex items-center gap-3">
                <label class="text-sm text-textSecondary font-medium">Inventory Type</label>
                <select x-model="mode"
                        class="rounded-2xl border border-borderColor/70 bg-white px-4 py-2 text-sm focus:ring-primary/40 focus:border-primary/50">
                    <option value="phone">Phone Inventory</option>
                    <option value="computer">Computer Inventory</option>
                </select>
            </div>
            <form method="GET" action="{{ route('stock.index') }}" class="flex flex-1 items-center gap-2 md:max-w-md">
                <input type="text"
                       name="search"
                       value="{{ $searchTerm }}"
                       list="stock-search-options"
                       placeholder="Search by name, serial number, or product ID"
                       class="flex-1 rounded-2xl border border-borderColor/70 bg-white px-4 py-2 text-sm focus:ring-primary/40 focus:border-primary/50">
                @if($searchTerm)
                    <a href="{{ route('stock.index') }}"
                       class="text-sm text-textSecondary hover:text-primary transition">Clear</a>
                @endif
                <button type="submit"
                        class="px-4 py-2 rounded-2xl bg-primary text-white text-sm font-medium hover:bg-primary/90 transition">
                    Search
                </button>
            </form>
        </div>

        @if(!empty($searchSuggestions))
            <datalist id="stock-search-options">
                @foreach($searchSuggestions as $option)
                    <option value="{{ $option['value'] }}">{{ $option['label'] }}</option>
                @endforeach
            </datalist>
        @endif

        <div class="overflow-x-auto custom-scroll" x-show="mode === 'phone'" x-cloak>
            <table class="w-full text-sm">
                <thead class="bg-bgLight text-textSecondary uppercase text-xs tracking-wide">
                    <tr>
                        <th class="px-6 py-3 text-left">Product / Variation</th>
                        <th class="px-6 py-3 text-left">SKU</th>
                        <th class="px-6 py-3 text-left">Serial #</th>
                        <th class="px-6 py-3 text-center">Color</th>
                        <th class="px-6 py-3 text-center">Storage</th>
                        <th class="px-6 py-3 text-center">Remaining Qty</th>
                    </tr>
                </thead>
                <tbody class="bg-white">
                    @forelse($stock as $row)
                        <tr class="border-t border-borderColor/60 hover:bg-bgLight/50 transition">
                            <td class="px-6 py-4">
                                <p class="font-semibold text-textPrimary">{{ $row->product_name }}</p>
                                <p class="text-xs text-textSecondary">Variation #{{ $row->variation_id }}</p>
                            </td>
                            <td class="px-6 py-4 text-textSecondary">{{ $row->sku }}</td>
                            <td class="px-6 py-4 text-textSecondary">{{ $row->serial_number ?? '—' }}</td>
                            <td class="px-6 py-4 text-center text-textSecondary">{{ $row->color ?? '—' }}</td>
                            <td class="px-6 py-4 text-center text-textSecondary">{{ $row->storage ?? '—' }}</td>
                            <td class="px-6 py-4 text-center">
                                @if($row->quantity <= 0)
                                    <span class="px-3 py-1 rounded-full bg-red-50 text-red-600 font-semibold text-xs">Out</span>
                                @elseif($row->quantity < 5)
                                    <span class="px-3 py-1 rounded-full bg-amber-50 text-amber-600 font-semibold text-xs">Low ({{ $row->quantity }})</span>
                                @else
                                    <span class="px-3 py-1 rounded-full bg-emerald-50 text-emerald-600 font-semibold text-xs">{{ $row->quantity }}</span>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-10 text-center text-textSecondary">
                                No stock movement data available for this branch.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="overflow-x-auto custom-scroll p-6" x-show="mode === 'computer'" x-cloak>
            <div class="rounded-2xl border border-borderColor/70">
                <table class="w-full text-sm">
                    <thead class="bg-bgLight text-textSecondary uppercase text-xs tracking-wide">
                        <tr>
                            <th class="px-6 py-3 text-left">Product Name</th>
                            <th class="px-6 py-3 text-left">Product ID</th>
                            <th class="px-6 py-3 text-left">Specs</th>
                            <th class="px-6 py-3 text-center">Country</th>
                            <th class="px-6 py-3 text-center">Condition</th>
                            <th class="px-6 py-3 text-center">Stock Qty</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white" x-show="computerStock.length" x-cloak>
                        <template x-for="item in computerStock" :key="item.id">
                            <tr class="border-t border-borderColor/60">
                                <td class="px-6 py-4">
                                    <p class="font-semibold text-textPrimary" x-text="item.name"></p>
                                    <p class="text-xs text-textSecondary" x-text="`Display: ${item.display}`"></p>
                                </td>
                            <td class="px-6 py-4 text-textSecondary" x-text="item.product_code"></td>
                                <td class="px-6 py-4 text-sm text-textSecondary">
                                    <p x-text="`CPU: ${item.cpu}`"></p>
                                    <p x-text="`Storage: ${item.capacity} / ${item.ram} / ${item.storage}`"></p>
                                    <p x-text="`Color: ${item.color}`"></p>
                                </td>
                                <td class="px-6 py-4 text-center text-textSecondary" x-text="item.country_code"></td>
                                <td class="px-6 py-4 text-center text-textSecondary" x-text="item.condition"></td>
                                <td class="px-6 py-4 text-center">
                                    <span class="px-3 py-1 rounded-full text-xs"
                                          :class="item.stock_qty <= 0 ? 'bg-red-50 text-red-600' : 'bg-emerald-50 text-emerald-600'"
                                          x-text="item.stock_qty"></span>
                                </td>
                            </tr>
                        </template>
                    </tbody>
                    <tbody x-show="!computerStock.length" x-cloak>
                        <tr>
                            <td colspan="6" class="px-6 py-10 text-center text-textSecondary">
                                No computer stock found. <a href="{{ route('computers.create') }}" class="text-primary underline">Create a computer product</a> to add stock.
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</x-app-layout>
