<x-app-layout title="Sales">

    <div class="flex justify-between items-center mb-6">
        <h1 class="text-xl font-semibold">Sales</h1>

        @can('sales.create')
            <a href="{{ route('sales.create') }}"
               class="bg-primary text-white px-4 py-2 rounded-lg">
                + New Sale
            </a>
        @endcan
    </div>

    <div class="bg-white p-6 rounded-xl shadow border">
        <table class="w-full text-sm">
            <thead>
                <tr class="text-left border-b text-textSecondary">
                    <th class="py-2">Invoice</th>
                    <th class="py-2">Qty</th>
                    <th class="py-2">Total</th>
                    <th class="py-2">Payment Status</th>
                    <th class="py-2">Status</th>
                    <th class="py-2">Date</th>
                    <th></th>
                </tr>
            </thead>

            <tbody>
            @foreach ($sales as $s)
                <tr class="border-b">
                    <td class="py-3 font-semibold">{{ $s->invoice_number }}</td>
                    <td>{{ $s->total_qty ?? 0 }}</td>
                    <td>${{ number_format($s->total_amount, 2) }}</td>
                    <td>{{ $s->payment_method }}</td>
                    <td>{{ ucfirst($s->status) }}</td>
                    <td>{{ \Illuminate\Support\Carbon::parse($s->sale_date)->format('M d, Y') }}</td>
                    <td>
                        <a href="{{ route('sales.show', $s->id) }}" class="text-primary font-semibold">
                            View
                        </a>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>

        <div class="mt-4">
            {{ $sales->links() }}
        </div>
    </div>

</x-app-layout>
