<x-app-layout title="Repair Detail">

    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Repair</p>
            <h1 class="text-3xl font-semibold mt-2">{{ $repair->repair_code }}</h1>
            <p class="text-sm text-textSecondary mt-1">Device: {{ $repair->device_model }}</p>
        </div>
        <div class="flex items-center gap-3">
            <a href="{{ route('repairs.edit', $repair->id) }}" class="px-4 py-2 rounded-xl bg-bgLight text-textPrimary text-sm">Edit</a>
            <form action="{{ route('repairs.destroy', $repair->id) }}" method="POST" onsubmit="return confirm('Delete this repair?')">
                @csrf
                @method('DELETE')
                <button class="px-4 py-2 rounded-xl bg-red-100 text-red-600 text-sm">Delete</button>
            </form>
            <a href="{{ route('repairs.index') }}" class="text-primary hover:underline text-sm">Back</a>
        </div>
    </div>

    <div class="grid md:grid-cols-2 gap-6 mt-8">
        <div class="bg-white border border-borderColor rounded-3xl p-6 space-y-4 shadow-sm">
            <h2 class="text-lg font-semibold text-textPrimary">Summary</h2>
            <div class="flex justify-between text-sm text-textSecondary">
                <span>Customer</span>
                <span class="font-semibold text-textPrimary">{{ $repair->customer_id }}</span>
            </div>
            <div>
                <p class="text-sm text-textSecondary">Issue Description</p>
                @php
                    $issueLines = collect(preg_split('/\r\n|\r|\n/', $repair->issue ?? ''))->filter();
                @endphp
                <ul class="text-textPrimary mt-2 list-disc list-inside space-y-1">
                    @forelse($issueLines as $issue)
                        <li>{{ $issue }}</li>
                    @empty
                        <li>No issues recorded.</li>
                    @endforelse
                </ul>
            </div>
            <div>
                <p class="text-sm text-textSecondary">Status</p>
                <p class="badge-pill bg-blue-50 text-blue-600 mt-1">{{ ucwords(str_replace('_', ' ', $repair->status)) }}</p>
            </div>
            <div>
                <p class="text-sm text-textSecondary">Created</p>
                <p>{{ $repair->created_at?->format('M d, Y H:i') }}</p>
            </div>
        </div>

        <div class="bg-white border border-borderColor rounded-3xl p-6 shadow-sm">
            <h2 class="text-lg font-semibold text-textPrimary mb-4">Items / Notes</h2>
            <div class="space-y-3">
                @forelse($repair->items as $item)
                    <div class="rounded-2xl border border-borderColor/60 bg-white px-4 py-3 text-sm">
                        <p class="font-semibold text-textPrimary">{{ $item->description ?? 'Item' }}</p>
                        <p class="text-textSecondary text-xs">Cost: ${{ number_format($item->cost ?? 0, 2) }}</p>
                    </div>
                @empty
                    <p class="text-sm text-textSecondary">No repair items recorded.</p>
                @endforelse
            </div>
        </div>
    </div>

</x-app-layout>
