<x-app-layout title="Purchase Order {{ $purchase->po_number }}">

    <h1 class="text-xl font-semibold mb-6">Purchase Order: {{ $purchase->po_number }}</h1>

    <div class="bg-white rounded-xl shadow p-6 border mb-6">
        <p class="text-sm"><strong>Supplier:</strong> {{ $purchase->supplier->name }}</p>
        <p class="text-sm"><strong>Date:</strong> {{ $purchase->purchase_date }}</p>
        <p class="text-sm"><strong>Type:</strong> {{ ucfirst($purchase->purchase_type ?? 'phone') }}</p>
        <p class="text-sm"><strong>Status:</strong> {{ ucfirst($purchase->status) }}</p>
        <p class="text-sm"><strong>Total:</strong> ${{ number_format($purchase->total_amount, 2) }}</p>
    </div>

    <div class="bg-white rounded-xl shadow p-6 border">

        <h2 class="text-lg font-semibold mb-4">Items</h2>

        <table class="w-full text-sm mb-4">
            <thead>
                <tr class="text-left border-b text-textSecondary">
                    <th class="py-2">Item</th>
                    <th class="py-2">Qty</th>
                    <th class="py-2">Cost</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($purchase->items as $i)
                    <tr class="border-b">
                        <td class="py-3">
                            @if($purchase->purchase_type === 'computer')
                                {{ $i->computerProduct->name ?? 'Computer' }}
                                @if($i->computerProduct?->product_code)
                                    ({{ $i->computerProduct->product_code }})
                                @endif
                                @if($i->serial_number)
                                    <span class="text-textSecondary"> · SN {{ $i->serial_number }}</span>
                                @endif
                            @else
                                {{ optional($i->variation->product)->name }}  
                                ({{ $i->variation->color }} / {{ $i->variation->storage }})
                            @endif
                        </td>
                        <td>{{ $i->qty }}</td>
                        <td>${{ $i->cost_price }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        @if ($purchase->status == 'pending')
            <form action="{{ route('purchases.receive', $purchase->id) }}" method="POST">
                @csrf
                <button class="bg-green-600 text-white px-4 py-2 rounded-lg">
                    Receive Items
                </button>
            </form>
        @endif

    </div>

</x-app-layout>
