<x-app-layout title="Profile">

    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-8">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Account</p>
            <h1 class="text-3xl font-semibold mt-2">{{ $user->name }}</h1>
            <p class="text-sm text-textSecondary">{{ $user->email }}</p>
        </div>
        <a href="{{ route('profile.edit') }}"
           class="px-4 py-2 rounded-2xl bg-primary text-white text-sm font-semibold shadow-sm">
            Edit Profile
        </a>
    </div>

    <div class="grid gap-6 md:grid-cols-2">
        <div class="bg-white border border-borderColor rounded-3xl shadow-sm p-6 space-y-4">
            <h2 class="text-lg font-semibold text-textPrimary">Personal Details</h2>
            <div class="text-sm">
                <p class="text-textSecondary">Name</p>
                <p class="font-semibold text-textPrimary">{{ $user->name }}</p>
            </div>
            <div class="text-sm">
                <p class="text-textSecondary">Email</p>
                <p class="font-semibold text-textPrimary">{{ $user->email }}</p>
            </div>
            <div class="text-sm">
                <p class="text-textSecondary">Branch</p>
                <p class="font-semibold text-textPrimary">{{ $user->branch->name ?? 'Not assigned' }}</p>
            </div>
            <div class="text-sm">
                <p class="text-textSecondary">Joined</p>
                <p class="font-semibold text-textPrimary">{{ $user->created_at?->format('M d, Y') }}</p>
            </div>
        </div>

        <div class="bg-white border border-borderColor rounded-3xl shadow-sm p-6 space-y-4">
            <h2 class="text-lg font-semibold text-textPrimary">Security</h2>
            <div class="text-sm">
                <p class="text-textSecondary">Password</p>
                <p class="font-semibold text-textPrimary">••••••••</p>
                <a href="{{ route('profile.edit') }}#update-password" class="text-primary text-xs">Update password</a>
            </div>
            <div class="text-sm">
                <p class="text-textSecondary">Two Factor Authentication</p>
                <p class="font-semibold text-textPrimary">Manage from settings</p>
            </div>
        </div>
    </div>

</x-app-layout>
