<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans text-slate-900 antialiased bg-slate-100">
        <div class="min-h-screen flex items-center justify-center px-4 py-10">
            <div class="w-full max-w-2xl bg-white border border-slate-200 shadow-lg rounded-2xl overflow-hidden">
                <div class="flex items-center gap-3 px-8 pt-8">
                    <img src="{{ asset('img/logo_lanscate.png') }}" alt="Lanscate logo" class="object-contain">
                    <div>
                        {{-- <p class="text-xs uppercase tracking-[0.25em] text-slate-400">Phone Inventory</p> --}}
                        {{-- <p class="text-xl font-semibold text-slate-900">{{ config('app.name', 'Inventory') }}</p> --}}
                    </div>
                </div>

                <div class="px-8 pb-10 pt-6">
                    {{ $slot }}
                </div>
            </div>
        </div>
    </body>
</html>
