<x-app-layout title="Expenses">

    <h1 class="text-xl font-semibold mb-6">Expenses</h1>

    @can('expenses.create')
    <div class="bg-white border border-borderColor rounded-3xl shadow-sm p-6 mb-8">
        <form action="{{ route('expenses.store') }}" method="POST" class="grid md:grid-cols-5 gap-4">
            @csrf

            <div class="md:col-span-2 space-y-2">
                <label class="text-sm text-textSecondary font-medium">Category</label>
                <div class="flex gap-2">
                    <select name="category"
                            class="w-1/2 rounded-2xl border border-borderColor px-3 py-2 focus:ring-primary/40 focus:border-primary/50">
                        <option value="" disabled selected>Select preset</option>
                        @foreach (['Electricity', 'Water', 'WiFi', 'Employees', 'Training & software', 'Tax Registration', 'CCTV', 'Printer'] as $category)
                            <option value="{{ $category }}">{{ $category }}</option>
                        @endforeach
                    </select>
                    <input name="category_custom" type="text" placeholder="Or type custom"
                           class="w-1/2 rounded-2xl border border-borderColor px-3 py-2 focus:ring-primary/40 focus:border-primary/50">
                </div>
            </div>

            <div>
                <label class="text-sm text-textSecondary font-medium">Amount</label>
                <input name="amount" type="number" step="0.01" placeholder="Amount"
                       class="w-full rounded-2xl border border-borderColor px-3 py-2 focus:ring-primary/40 focus:border-primary/50" required>
            </div>

            <div>
                <label class="text-sm text-textSecondary font-medium">Payment Type</label>
                <select name="payment_type"
                        class="w-full rounded-2xl border border-borderColor px-3 py-2 focus:ring-primary/40 focus:border-primary/50">
                    <option value="" disabled selected>Select method</option>
                    @foreach($paymentMethods as $method)
                        <option value="{{ $method }}">{{ $method }}</option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="text-sm text-textSecondary font-medium">Date</label>
                <input name="expense_date" type="date"
                       class="w-full rounded-2xl border border-borderColor px-3 py-2 focus:ring-primary/40 focus:border-primary/50" value="{{ now()->toDateString() }}">
            </div>

            <div class="md:col-span-5 flex justify-end">
                <button class="px-6 py-3 rounded-2xl bg-primary text-white font-semibold shadow-sm">
                    Add Expense
                </button>
            </div>
        </form>
    </div>
    @endcan

    <div class="bg-white p-6 rounded-xl shadow border">
        <table class="w-full text-sm">
            <thead>
                <tr class="border-b text-textSecondary">
                    <th class="py-2">Category</th>
                    <th class="py-2">Amount</th>
                    <th class="py-2">Payment</th>
                    <th class="py-2">Date</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($expenses as $e)
                    <tr class="border-b">
                        <td class="py-3">{{ $e->category }}</td>
                        <td>${{ $e->amount }}</td>
                        <td>{{ $e->payment_type }}</td>
                        <td>{{ $e->expense_date }}</td>
                    </tr>
                @endforeach
            </tbody>

        </table>

        <div class="mt-4">
            {{ $expenses->links() }}
        </div>

    </div>

</x-app-layout>
