<x-app-layout :title="$computer->name">
    <div class="flex items-center justify-between flex-wrap gap-4">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Computer Product</p>
            <h1 class="text-3xl font-semibold mt-2">{{ $computer->name }}</h1>
            <p class="text-sm text-textSecondary mt-1">Product ID: {{ $computer->product_code }}</p>
        </div>
        <div class="flex items-center gap-3">
            <a href="{{ route('computers.index') }}" class="text-primary text-sm hover:underline">Back to list</a>
            <a href="{{ route('computers.edit', $computer) }}" class="px-4 py-2 rounded-2xl bg-primary text-white text-sm shadow shadow-primary/30">Edit</a>
            <form action="{{ route('computers.destroy', $computer) }}" method="POST" onsubmit="return confirm('Delete this computer product?');">
                @csrf
                @method('DELETE')
                <button type="submit" class="px-4 py-2 rounded-2xl bg-red-50 text-red-600 text-sm shadow">Delete</button>
            </form>
        </div>
    </div>

    @if (session('success'))
        <div class="mt-6 rounded-2xl border border-emerald-200 bg-emerald-50 text-emerald-700 px-4 py-2 text-sm">
            {{ session('success') }}
        </div>
    @endif

    <div class="glass-card rounded-3xl p-6 mt-8 grid md:grid-cols-2 gap-6">
        <div class="space-y-4">
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Description</p>
                <p class="text-lg font-semibold text-textPrimary">{{ $computer->description }}</p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">CodeName</p>
                <p class="text-lg font-semibold text-textPrimary">{{ $computer->code_name }}</p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Internal ID</p>
                <p class="text-lg font-semibold text-textPrimary">{{ $computer->internal_id }}</p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Display</p>
                <p class="text-lg font-semibold text-textPrimary">{{ $computer->display }}</p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">CPU</p>
                <p class="text-lg font-semibold text-textPrimary">{{ $computer->cpu }}</p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Capacity / RAM / Storage</p>
                <p class="text-lg font-semibold text-textPrimary">{{ $computer->capacity }} / {{ $computer->ram }} / {{ $computer->storage }}</p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Color</p>
                <p class="text-lg font-semibold text-textPrimary">{{ $computer->color_code }} - {{ $computer->color }}</p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Country</p>
                <p class="text-lg font-semibold text-textPrimary">{{ $computer->country_code }} - {{ $computer->country }}</p>
            </div>
        </div>

        <div class="space-y-4">
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Condition</p>
                <p class="text-lg font-semibold text-textPrimary">{{ $computer->condition }}</p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Activate</p>
                <p class="text-lg font-semibold text-textPrimary">{{ $computer->activate }}</p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Cost / Tax</p>
                <p class="text-lg font-semibold text-textPrimary">${{ number_format($computer->cost, 2) }} + ${{ number_format($computer->tax, 2) }}</p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Stock</p>
                <p class="text-lg font-semibold text-textPrimary">{{ $computer->stock_qty }}</p>
            </div>
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-textSecondary">Created / Updated</p>
                <p class="text-sm text-textPrimary">{{ $computer->created_at?->format('M d, Y g:i A') }} - {{ $computer->updated_at?->format('M d, Y g:i A') }}</p>
            </div>
        </div>
    </div>
</x-app-layout>
