<x-app-layout :title="'Edit '.$computer->name">
    @php
        $options = config('computers');
    @endphp

    <div class="flex items-center justify-between flex-wrap gap-4">
        <div>
            <p class="text-sm text-textSecondary uppercase tracking-[0.3em]">Computers</p>
            <h1 class="text-3xl font-semibold mt-2">Edit Computer Product</h1>
            <p class="text-sm text-textSecondary mt-1">Update specs, inventory, and identifiers.</p>
        </div>
        <a href="{{ route('computers.show', $computer) }}"
           class="inline-flex items-center px-4 py-2 rounded-2xl border border-white/60 text-sm text-textSecondary hover:text-primary">
            Back to details
        </a>
    </div>

    <div class="glass-card rounded-3xl p-6 mt-8">
        <form action="{{ route('computers.update', $computer) }}" method="POST" class="space-y-5">
            @csrf
            @method('PUT')
            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Product ID</label>
                    <input type="text" name="product_code" value="{{ old('product_code', $computer->product_code) }}"
                           class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary" readonly>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Description</label>
                    <input type="text" name="description" value="{{ old('description', $computer->description) }}"
                           class="w-full rounded-2xl border border-white/60 bg-slate-50 px-4 py-3 text-textSecondary cursor-not-allowed"
                           readonly>
                    <p class="text-xs text-textSecondary mt-1">Auto-generated from product attributes.</p>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">CodeName</label>
                    <select name="code_name" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select CodeName</option>
                        @foreach($options['code_names'] ?? [] as $option)
                            <option value="{{ $option }}" @selected(old('code_name', $computer->code_name) === $option)>{{ $option }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Product Name</label>
                    <select name="name" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Product Name</option>
                        @foreach($options['product_names'] ?? [] as $option)
                            <option value="{{ $option }}" @selected(old('name', $computer->name) === $option)>{{ $option }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Display</label>
                    <select name="display" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Display</option>
                        @foreach($options['displays'] ?? [] as $option)
                            <option value="{{ $option }}" @selected(old('display', $computer->display) === $option)>{{ $option }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">CPU</label>
                    <select name="cpu" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select CPU</option>
                        @foreach($options['cpus'] ?? [] as $option)
                            <option value="{{ $option }}" @selected(old('cpu', $computer->cpu) === $option)>{{ $option }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Capacity / Core</label>
                    <select name="capacity" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Capacity</option>
                        @foreach($options['capacities'] ?? [] as $option)
                            <option value="{{ $option }}" @selected(old('capacity', $computer->capacity) === $option)>{{ $option }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">RAM</label>
                    <select name="ram" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select RAM</option>
                        @foreach($options['rams'] ?? [] as $option)
                            <option value="{{ $option }}" @selected(old('ram', $computer->ram) === $option)>{{ $option }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Storage</label>
                    <select name="storage" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Storage</option>
                        @foreach($options['storages'] ?? [] as $option)
                            <option value="{{ $option }}" @selected(old('storage', $computer->storage) === $option)>{{ $option }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Color Code</label>
                    <select name="color_code" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Color Code</option>
                        @foreach($options['color_codes'] ?? [] as $option)
                            <option value="{{ $option }}" @selected(old('color_code', $computer->color_code) === $option)>{{ $option }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Color</label>
                    <select name="color" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Color</option>
                        @foreach($options['colors'] ?? [] as $option)
                            <option value="{{ $option }}" @selected(old('color', $computer->color) === $option)>{{ $option }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Country Code</label>
                    <select name="country_code" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Country Code</option>
                        @foreach($options['country_codes'] ?? [] as $option)
                            <option value="{{ $option }}" @selected(old('country_code', $computer->country_code) === $option)>{{ $option }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Country</label>
                    <select name="country" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Country</option>
                        @foreach($options['countries'] ?? [] as $option)
                            <option value="{{ $option }}" @selected(old('country', $computer->country) === $option)>{{ $option }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Condition</label>
                    <select name="condition" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Condition</option>
                        @foreach($options['conditions'] ?? [] as $option)
                            <option value="{{ $option }}" @selected(old('condition', $computer->condition) === $option)>{{ $option }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Activate</label>
                    <select name="activate" class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50" required>
                        <option value="">Select Activate</option>
                        @foreach($options['activates'] ?? [] as $option)
                            <option value="{{ $option }}" @selected(old('activate', $computer->activate) === $option)>{{ $option }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Internal ID</label>
                    <input type="text" name="internal_id" value="{{ old('internal_id', $computer->internal_id) }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           required>
                </div>
            </div>

            <div class="grid md:grid-cols-3 gap-4">
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Stock</label>
                    <input type="number" min="0" name="stock_qty" value="{{ old('stock_qty', $computer->stock_qty) }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           required>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Cost</label>
                    <input type="number" step="0.01" min="0" name="cost" value="{{ old('cost', $computer->cost) }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           required>
                </div>
                <div>
                    <label class="text-sm text-textSecondary font-medium mb-1 block">Tax</label>
                    <input type="number" step="0.01" min="0" name="tax" value="{{ old('tax', $computer->tax) }}"
                           class="w-full rounded-2xl border border-white/60 bg-white/80 px-4 py-3 focus:ring-primary/40 focus:border-primary/50"
                           required>
                </div>
            </div>

            @if ($errors->any())
                <div class="rounded-2xl border border-red-200 bg-red-50 text-red-600 text-sm px-4 py-3">
                    <ul class="list-disc list-inside space-y-1">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="flex justify-end gap-3">
                <a href="{{ route('computers.show', $computer) }}"
                   class="px-4 py-2 rounded-2xl border border-white/60 text-textSecondary">Cancel</a>
                <button type="submit"
                        class="px-6 py-3 rounded-2xl bg-gradient-to-r from-primary to-primaryDark text-white shadow-lg shadow-primary/40">
                    Save Changes
                </button>
            </div>
        </form>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const descriptionInput = document.querySelector('input[name="description"]');
            if (!descriptionInput) {
                return;
            }

            const readValue = (selector) => {
                const field = document.querySelector(selector);
                return field ? String(field.value || '').trim() : '';
            };

            const buildDescription = () => {
                const productName = readValue('select[name="name"]');
                const display = readValue('select[name="display"]');
                const cpu = readValue('select[name="cpu"]');
                const capacity = readValue('select[name="capacity"]');
                const ram = readValue('select[name="ram"]');
                const storage = readValue('select[name="storage"]');
                const color = readValue('select[name="color"]');
                const country = readValue('select[name="country"]');
                const condition = readValue('select[name="condition"]');
                const activate = readValue('select[name="activate"]');

                const main = [productName, display].filter(Boolean).join(' ').trim();
                const specs = [
                    cpu,
                    capacity,
                    ram,
                    storage,
                    color,
                    country,
                    condition,
                    activate,
                ].filter(Boolean).join(' ').trim();

                if (main && specs) {
                    descriptionInput.value = `${main} - ${specs}`;
                } else {
                    descriptionInput.value = main || specs;
                }
            };

            [
                'select[name="name"]',
                'select[name="display"]',
                'select[name="cpu"]',
                'select[name="capacity"]',
                'select[name="ram"]',
                'select[name="storage"]',
                'select[name="color"]',
                'select[name="country"]',
                'select[name="condition"]',
                'select[name="activate"]',
            ].forEach((selector) => {
                const field = document.querySelector(selector);
                if (!field) {
                    return;
                }
                field.addEventListener('change', buildDescription);
                field.addEventListener('input', buildDescription);
            });

            buildDescription();
        });
    </script>
</x-app-layout>
