<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Product;
use App\Models\ProductVariation;

class ProductSeeder extends Seeder
{
    public function run()
    {
        $product = Product::create([
            'name' => 'iPhone 13 Pro Max',
            'category_code' => Product::nextCategoryCode(),
            'selling_price' => 1200,
            'cost_price' => 900,
        ]);

        ProductVariation::create([
            'product_id' => $product->id,
            'color' => 'Blue',
            'storage' => '128GB',
            'sku' => ProductVariation::nextSku(),
            'condition' => 'New',
        ]);
    }
}
