<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('computer_products', function (Blueprint $table) {
            $table->text('description')->nullable()->after('product_code');
            $table->string('code_name')->nullable()->after('description');
            $table->string('internal_id')->nullable()->after('code_name');
            $table->string('color_code')->nullable()->after('storage');
            $table->string('country')->nullable()->after('country_code');
            $table->string('activate')->nullable()->after('condition');
        });
    }

    public function down(): void
    {
        Schema::table('computer_products', function (Blueprint $table) {
            $table->dropColumn([
                'description',
                'code_name',
                'internal_id',
                'color_code',
                'country',
                'activate',
            ]);
        });
    }
};
