<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (! Schema::hasColumn('products', 'category_code')) {
            Schema::table('products', function (Blueprint $table) {
                $table->string('category_code')->nullable()->after('name');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('products', 'category_code')) {
            Schema::table('products', function (Blueprint $table) {
                $table->dropColumn('category_code');
            });
        }
    }
};
