<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PurchaseItem extends Model
{
    protected $fillable = [
        'purchase_id',
        'product_type',
        'variation_id',
        'computer_product_id',
        'qty',
        'cost_price',
        'serial_number'
    ];

    public function purchase()
    {
        return $this->belongsTo(Purchase::class);
    }

    public function variation()
    {
        return $this->belongsTo(ProductVariation::class);
    }

    public function computerProduct()
    {
        return $this->belongsTo(ComputerProduct::class);
    }
}
