<?php

namespace App\Listeners;

use App\Events\StockUpdated;
use App\Services\FirebaseService;

class SyncStockToFirebase
{
    public function handle(StockUpdated $event)
    {
        $movement = $event->movement;

        $stockQty = \DB::table('stock_movements')
            ->where('branch_id', $movement->branch_id)
            ->where('variation_id', $movement->variation_id)
            ->sum('qty');

        (new FirebaseService)->updateStock(
            $movement->variation_id,
            $movement->branch_id,
            $stockQty
        );
    }
}
