<?php

namespace App\Listeners;

use App\Events\SaleCreated;
use App\Services\FirebaseService;

class SyncSaleToFirebase
{
    public function handle(SaleCreated $event)
    {
        $sale = $event->sale;

        (new FirebaseService)->logSale(
            $sale->invoice_number,
            [
                'branch_id' => $sale->branch_id,
                'total_amount' => $sale->total_amount,
                'date' => $sale->sale_date,
            ]
        );
    }
}
