<?php

namespace App\Helpers;

class NumberHelper
{
    public static function generate($prefix, $model)
    {
        $latest = $model::orderBy('id', 'DESC')->first();

        $number = $latest ? $latest->id + 1 : 1;

        return $prefix . '-' . str_pad($number, 5, '0', STR_PAD_LEFT);
    }

    public static function generateTimestampCode(string $prefix, string $format = 'YmdHis'): string
    {
        return $prefix . '-' . now()->format($format);
    }
}
